<?php

namespace WPStaging\Pro\Backup\Task\Tasks\JobRestore;

use RuntimeException;
use WPStaging\Backup\Entity\BackupMetadata;
use WPStaging\Backup\Task\Tasks\JobRestore\RestoreRequirementsCheckTask as BasicRestoreRequirementsCheckTask;

class RestoreRequirementsCheckTask extends BasicRestoreRequirementsCheckTask
{
    /**
     * @return void
     */
    protected function cannotRestoreOnMultisite()
    {
        /** @var BackupMetadata */
        $metadata = $this->jobDataDto->getBackupMetadata();

        // Early bail if not multisite
        if (!is_multisite()) {
            return;
        }

        if ($metadata->getBackupType() !== BackupMetadata::BACKUP_TYPE_MULTISITE) {
            $link = 'https://wp-staging.com/convert-network-site-to-single/';
            throw new RuntimeException(sprintf(esc_html__('This backup cannot yet be restored to a network subsite. This feature will be available soon. You can restore this backup to a single site. For example, you can use it to convert this network subsite to a single site. %s', 'wp-staging'), '<a href="' . esc_url($link) . '" target="_blank">' . esc_html__('Read More', 'wp-staging') . '</a>'));
        }

        if (!current_user_can('setup_network')) {
            throw new RuntimeException(esc_html__('Only a network administrator can restore an entire multisite network backup. Please ask your network administrator to restore this backup.', 'wp-staging'));
        }
    }

    /**
     * @return void
     */
    protected function cannotMigrate()
    {
        // no-op
    }

    /**
     * @return void
     */
    protected function cannotRestoreMultipartBackup()
    {
        // no-op
    }

    /**
     * @return void
     */
    protected function cannotRestoreIfBackupGeneratedOnProVersion()
    {
        // no-op
    }
}
